package gov.va.genisis2.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

import gov.va.genisis2.vo.GenisisProperties;

@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
@PropertySource("file:${jboss.server.config.dir}/genisis2.properties")
public class GenisisPropertiesUpload {
	
	@Value("${activiti.datasourcemanaager.list.email.notification}")
	private String datasourcemanagers;
	
	
	@Bean
	protected GenisisProperties getGenisisProperties() {
		return new GenisisProperties(datasourcemanagers);
	}
	
	
	/**
	 * @return the datasourcemanagers
	 */
	public String getDatasourcemanagers() {
		return datasourcemanagers;
	}



	@Bean
	public static PropertySourcesPlaceholderConfigurer placeHolderConfigurer() {
		return new PropertySourcesPlaceholderConfigurer();
	}

}
